/*****************************************************************************/
/*Fichier : main.cpp Auteur : Pierre Tardy, Gerard Genieys, ISIMA      */
/*Description : interface de rendez vous        		             */
/*             							             */
/*****************************************************************************/


#include "emu.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcpu_opcodes/fcpu_opcodes.h>
extern "C"
{
#if INSTRUCTION_BIG_ENDIAN
#define INSN(x)	(char)((x)>>24),(char)((x)>>16),(char)((x)>>8),(char)(x)
#else
#define INSN(x)	(char)(x),(char)((x)>>8),(char)((x)>>16),(char)((x)>>24)
#endif

#define X(op)	((op)<<24)

char smoke_test[] = {
	/* loadaddri $target-.-4, r1 */
	INSN(X(OP_LOADADDRI) | 28 << 6 | 1 << 0),
	/* jmp r1, r3 */
	INSN(X(OP_JMP) | 1 << 6 | 3 << 0),
	/* .string */
	's','m','o','k','e',' ','t','e',
	's','t',' ','s','u','c','c','e',
	's','s','f','u','l','!','\n',0,
	/* inc r0, r2 */
	INSN(X(OP_INC) | ISIZE_64BIT | 0 << 6 | 2 << 0),
	/* loadconsx.0 $23, r4 */
	INSN(X(OP_LOADCONSX) | 23 << 6 | 4 << 0),
	/* loadconsx.0 $2, r1 */
	INSN(X(OP_LOADCONSX) | 2 << 6 | 1 << 0),
	/* syscall $0, r0 */
	INSN(X(OP_SYSCALL) | 0 << 6 | 0 << 0),
	/* nop */
	INSN(X(OP_NOP)),
	/* halt */
	INSN(X(OP_HALT)),
};

#undef X
  /* target -> host memory mapping */
  unsigned char *addrbase;	/* F-CPU core memory is mapped here */
  size_t ramsize;		       	/* total amount of RAM available for emulation */

  void fcpu_ram_init(char*file)
  {
    ramsize = 32 << 20;

    fprintf(stderr, "RAM size set to %lu MB\n", (unsigned long)ramsize >> 20);
#if HAVE_MMAP && defined(MAP_ANONYMOUS)
    addrbase = mmap(0, ramsize, PROT_READ | PROT_WRITE,
		    MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);
    if (addrbase == (unsigned char*)MAP_FAILED) {
#else
      if (1) {
#endif
	addrbase =(unsigned char*) malloc(ramsize);
	if (addrbase == NULL) {
	  perror("malloc");
	  exit(1);
	}
      }
#if 0
    }
#endif
    if (file!=0) {
      struct stat st;
      int x;
      unsigned char *p;
      if ((x = open(file, O_RDONLY)) == -1) {
	perror(file);
	exit(1);
      }
      if (fstat(x, &st)) {
	perror("fstat");
	exit(1);
      }
      if (st.st_size == 0) {
	fprintf(stderr, "%s: empty file\n", file);
	exit(1);
      }
#if HAVE_MMAP
      p = mmap(addrbase, st.st_size, PROT_READ | PROT_WRITE,
	       MAP_PRIVATE | MAP_FIXED, x, 0);
      if (p == (unsigned char*)MAP_FAILED) {
#else
	if (1) {
#endif
	  size_t n = 0, nread = 0;
      
	  fprintf(stderr, "warning: mmap failed, trying read\n");
	  while (nread < ramsize
		 &&     (n = read(x, addrbase + nread, ramsize - nread)) > 0) {
	    nread += n;
	  }
	  if (n == (size_t)-1) {
	    perror("read");
	    exit(1);
	  }
	}
	else if (p != addrbase) {
	  fprintf(stderr, "mapping failed\n");
	  exit(1);
	}
	close(x);
      }
      else {
	memcpy(addrbase, &smoke_test, sizeof(smoke_test));
      }

    }
    void*
      memmap(U64 virtaddr, U64 align, U64 len, int write_mode) {
      /* no MMU for now */
      if (len > ramsize) {
	ex(EX_ADDRESS);
	return NULL;
      }
      if (virtaddr >= ramsize) {
	ex(EX_ADDRESS);
	return NULL;
      }
      if (virtaddr + len > ramsize) {
	ex(EX_ADDRESS);
	return NULL;
      }
      if (align > 1 && virtaddr % align) {
	ex(EX_ALIGNMENT);
      }
      return addrbase + virtaddr;
    }

    U32
      fetch(U64 ip) { // get instruction directly from memory (no L0 cache)
      unsigned char *p = (unsigned char *)memmap(ip, 4, 4, 0);
      U32 insn = 0;

      if (!p) return 0xffffffff;
#if INSTRUCTION_BIG_ENDIAN
      insn = (insn << 8) | p[0];
      insn = (insn << 8) | p[1];
      insn = (insn << 8) | p[2];
      insn = (insn << 8) | p[3];
#else
      insn = (insn << 8) | p[3];
      insn = (insn << 8) | p[2];
      insn = (insn << 8) | p[1];
      insn = (insn << 8) | p[0];
#endif
      return insn;
    }

    unsigned char data_load(U64 addr) {
      return *(unsigned char*)memmap(addr, 1, 1, 0) ;
    }

    void data_store(U64 addr, unsigned char data) {
      *(unsigned char *)memmap(addr, 1, 1, 0)  = data ;
    }

  }
