#ifndef __DCACHE_H
#define __DCACHE_H

/* #include "emu.h"  */

/*************************************************************************
 *  F-CPU Level-0 data cache(or L/S Unit , part of the cached emulator.  *
 *  ------------------------------------------------------               *
 *                                                                       *
 *  Please note : The core is responsible for signaling any change       *
 *      of a register that may break its binding to a line of the cache  *
 *           (function : lsu_break_reg_line_mapping(int reg_num)          *
 *************************************************************************/


#ifndef LSU_NUMLINE 
#define LSU_NUMLINE 8
#endif

#ifndef LSU_LINEWIDTH
/* this MUST be a power of 2, for efficient address mapping */
#define LSU_LINEWIDTH 16
#endif

#ifdef NUM_REG  
#define FCPU_NUM_REG NUM_REG
#else 
#define FCPU_NUM_REG 10
#endif

/* these #define assume that LSU_LINEWIDTH is a power of 2 */
#define LSU_LO_ADDR_MASK (LSU_LINEWIDTH-1) 
#define LSU_HI_ADDR_MASK (~LSU_LO_ADDR_MASK) 



void lsu_init() ;
void lsu_doPrefetch() ;
unsigned char lsu_do_read(U64 addr, int num_reg) ;
void lsu_do_write(U64 addr, int num_reg, unsigned char data) ;

unsigned char lsu_read(U64 addr, int num_reg) ;
void lsu_write(U64 addr, int num_reg, unsigned char data) ;
void lsu_break_reg_line_mapping(int reg_num) ;
void lsu_loadaddr(int num_reg, U64 addr) ;
void lsu_flush();


void lsu_dump() ;

#endif
