/*****************************************************************************/
/*Fichier : main.cpp Auteur : Pierre Tardy, Gerard Genieys, ISIMA      */
/*Description : interface de rendez vous        		             */
/*             							             */
/*****************************************************************************/


#include "L1I.hh"
#include "L1Iveryslow.hh"
#include "L1D.hh"
#include "fcpu.hh"

extern ram_read_if<U32, 4> *i_cache ;
extern ram_read_write_if<unsigned char, 16> *d_cache ;

extern "C"
{
  BOOL L1DoLoadMem(U64 addr)
  {
    return i_cache->request(addr);
  }
  U32 getL1Data(int i)
  {
    return i_cache->getData(i);
    
  }
  BOOL L1DataGetData(U64 addr, void * target) 
  {
    if (!d_cache->request(addr)) 
      return false ;
    for(int i = 0 ; i<16 ;++i)
      ((unsigned char *)target)[i] = d_cache->getData(i) ;
    return true ;
  }
  BOOL L1DataDoWriteMem(U64 addr, void * source)
  {
    return d_cache->write(addr, (unsigned char *)source) ;
  }


}
