/*****************************************************************************/
/*Fichier : L1I.hh Auteur : Pierre Tardy, Gerard Genieys, ISIMA      */
/*Description : interface de rendez vous        		             */
/*             							             */
/*****************************************************************************/

#ifndef _L1IVERYSLOW_H_
#define _L1IVERYSLOW_H_


#include "ram_interface.hh"
#include "emu.h"
template <int numdata,int numcycle>
class L1Iveryslow: virtual public ram_read_if<U32, numdata> 
{
private:
  U64 lastPC;
  int cycle;

public:
  //sc_clk *clk;

  virtual void register_port( sc_port_base& port_,
			      const char*    if_typename_ ){} // page 46
  virtual U32 getData(int i) {
    return fetch(lastPC+i*4);
  }
  virtual BOOL request(U64 addr) {
    if(lastPC !=addr)
      {
	cycle = 0;
	lastPC = addr;
      }
    wait();
    if(cycle++ > numcycle)
      {
	return true;
      }
    return false;
  }

public:

  L1Iveryslow()
  {
    lastPC = 0;
    cycle = 0;
  }
};
#endif
