/*****************************************************************************/
/*Fichier : L1I.hh Auteur : Pierre Tardy, Francois Vieville, ISIMA           */
/*Description : This cache implement a very simple infinite cache..          */
/*             							             */
/*****************************************************************************/

#ifndef _L1I_H_
#define _L1I_H_


#include "ram_interface.hh"
#include "emu.h"
#include <map>    // use of the STL map data structure

template <class T, int numdata,int numcycleMISS,int numcycleHIT>
class L1I: virtual public ram_read_if<T, numdata> 
{
private:
  U64 lastPC;
  int cycle;
  map<U64, bool> alreadyFetched;
public:
  //  sc_in_clk clk;

  virtual void register_port( sc_port_base& port_,
			      const char*    if_typename_ ){} // page 46
  virtual T getData(int i) {
    alreadyFetched[lastPC] = true;
    return fetch(lastPC+i*sizeof(T));   // TODO : REMARQUE :  externaliser hors de emu.c ? 
  }
  virtual BOOL request(U64 addr) {
    if(alreadyFetched.count(addr)==0)// be sure that a new value is false
      alreadyFetched[addr] = false;
    int numcycle = alreadyFetched[addr] ? numcycleHIT:numcycleMISS;
    if(lastPC !=addr)
      {
	cycle = 0;
	lastPC = addr;
      }
    if(cycle++ > numcycle)
      {
	return true;
      }
    return false;
  }

public:

  L1I()
  {
    lastPC = 0;
    cycle = 0;
  }
};
#endif
