/*****************************************************************************/
/*Fichier : L1D.hh Auteur : Pierre Tardy, Francois Vieville, ISIMA           */
/*Description : This cache implement a very simple infinite cache..          */
/*             							             */
/*****************************************************************************/

#ifndef _L1D_H_
#define _L1D_H_


#include "ram_interface.hh"
#include "emu.h"
#include <map> // use of the STL map data structure

template <class T, int numdata,int numcycleMISS,int numcycleHIT>
class L1D: virtual public ram_read_write_if<T, numdata>
{
private:
  U64 lastPC;
  int cycle;
  map<U64, bool> alreadyFetched;
public:
  //  sc_in_clk clk;
  
  virtual void register_port( sc_port_base& port_,
			      const char*    if_typename_ ){} // page 46
  virtual T getData(int i) {
    alreadyFetched[lastPC] = true;
    return data_load(lastPC+i*sizeof(T));   // TODO : REMARQUES : 1. 4 -> numdata (template) ?
  }
  virtual BOOL request(U64 addr) {
    if(alreadyFetched.count(addr)==0)// be sure that a new value is false
      alreadyFetched[addr] = false;
    int numcycle = alreadyFetched[addr] ? numcycleHIT:numcycleMISS;
    if(lastPC !=addr)
      {
	cycle = 0;
	lastPC = addr;
      }
    if(cycle++ > numcycle)
      {
	return true;
      }
    return false;
  }
  virtual BOOL write(U64 addr, T * source) {
    if(alreadyFetched.count(addr)==0)// be sure that a new value is false
      alreadyFetched[addr] = false;
    int numcycle = alreadyFetched[addr] ? numcycleHIT: numcycleMISS ;
    if(lastPC != addr)
      {
	cycle = 0;
	lastPC = addr;
      }
    if(cycle++ > numcycle)
      {
	for(int i = 0 ; i<numdata ; ++i)
	  data_store(lastPC+i*sizeof(T), source[i]) ;
	return true;
      }
    return false;

  }

public:

  L1D()
  {
    lastPC = 0;
    cycle = 0;
  }
};
#endif
