% Classe fcpu.cls - Version 1.0
% O. JEAN  DEC 2000
%
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{fcpu}[27/08/2002 v1.99 Classe fcpu]
%
% This class is based on report's class
%
\LoadClass[a4paper,10pt] {report}
%
% Package required
%
\RequirePackage{longtable}      % for the long table ( several pages )
\RequirePackage[normalem]{ulem} % for the long underline ( several lines )
\RequirePackage{trees}          % to build tree
\RequirePackage{url}            % to manage the url address 
\RequirePackage{float}
\RequirePackage{graphicx}       % to manage the figure included into the tex
\RequirePackage{makeidx}
% \RequirePackage{amssymb} commented by YG jan. 4, 2001
%
% Modification of parameters about page
%
\setlength{\textwidth}{16cm}
\setlength{\marginparwidth}{0.75cm}
\setlength{\headheight}{0.75cm}
\setlength{\topmargin}{0.75cm}
\setlength{\voffset}{-2.54cm}
\setlength{\hoffset}{-2.54cm}
\setlength{\textheight}{26cm}

%
% Added by Cedric BAIL august 19, 2002
%
% Add some macro for cleaner text and color
%
\usepackage{color}
\usepackage{colortbl}
\usepackage{multirow}

\newcommand{\xor}[0]{\symbol{94}}

\definecolor{orange}{rgb}{0.941176, 0.627451, 0.411765}
\definecolor{green}{rgb}{0.627451, 0.9, 0.117647}
\definecolor{yellow}{rgb}{0.941176, 0.941176, 0.470588}
\definecolor{red}{rgb}{0.980392, 0.3921157, 0.392157}

\newlength{\myrecoversize}

\newcommand{\revised}[1]{
  \setlength{\myrecoversize}{\columnwidth}
  \addtolength{\myrecoversize}{-2\fboxsep}
  \addtolength{\myrecoversize}{-2\fboxrule}
  \colorbox{green}{\parbox[c]{\myrecoversize}{\centering{\textbf{Revised (#1)}}}}
}
\newcommand{\updated}[1]{
  \setlength{\myrecoversize}{\columnwidth}
  \addtolength{\myrecoversize}{-2\fboxsep}
  \addtolength{\myrecoversize}{-2\fboxrule}
  \colorbox{orange}{\parbox[c]{\myrecoversize}{\centering{\textbf{Updated (#1)}}}}
}
\newcommand{\change}[1]{
  \setlength{\myrecoversize}{\columnwidth}
  \addtolength{\myrecoversize}{-2\fboxsep}
  \addtolength{\myrecoversize}{-2\fboxrule}
  \colorbox{yellow}{\parbox[c]{\myrecoversize}{\centering{\textbf{Subject to change (#1)}}}}
}
\newcommand{\deprecated}[1]{
  \setlength{\myrecoversize}{\columnwidth}
  \addtolength{\myrecoversize}{-2\fboxsep}
  \addtolength{\myrecoversize}{-2\fboxrule}
  \colorbox{red}{\parbox[c]{\myrecoversize}{\centering{\textbf{Deprecated (#1)}}}}
}

%
% Background color for table header
%
\newcolumntype{R}{
  >{\color{black}\columncolor{orange}[\tabcolsep]}r
}
\newcolumntype{C}{
  >{\color{black}\columncolor{orange}[\tabcolsep]}c
}


%
% ISA instructions
%

\newcommand{\isarw}[1]{
 \begin{tabular}{|R|c|c|c|c|c|}
  \hline
 size : & 8 & 6 & 6 & 6 & 6 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23 ~ ~ ~ ~ ~ ~ 18
  & 17 ~ ~ ~ ~ ~ ~ 12
  & 11 ~ ~ ~ ~ ~ ~ 6
  & 5 ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1 & Flags & 0 & Reg 2 & Reg 1 \\
  \hline
 \end{tabular}
}

\newcommand{\isarwnf}[1]{
 \begin{tabular}{|R|c|c|c|c|}
  \hline
 size : & 8 & 12 & 6 & 6 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ 12
  & 11 ~ ~ ~ ~ ~ ~ 6
  & 5 ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1 & 0 & Reg 2 & Reg 1\\
  \hline
 \end{tabular}
}

\newcommand{\isaiw}[1]{
 \begin{tabular}{|R|c|c|c|c|}
  \hline
 size : & 8 & 2 & 16 & 6 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23 ~ ~ 22
  & 21 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ 6
  & 5 ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1  & Flags & Imm16 & Reg 1 \\
  \hline
 \end{tabular}
}

\newcommand{\isaiwnf}[1]{
 \begin{tabular}{|R|c|c|c|c|}
  \hline
 size : & 8 & 2 & 16 & 6 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23 ~ ~ 22
  & 21 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ 6
  & 5 ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1 & 0 & Imm16 & Reg 1\\
  \hline
 \end{tabular}
}

\newcommand{\isarrw}[1]{
 \begin{tabular}{|R|c|c|c|c|c|}
  \hline
 size : & 8 & 6 & 6 & 6 & 6 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23 ~ ~ ~ ~ ~ ~ 18
  & 17 ~ ~ ~ ~ ~ ~ 12
  & 11 ~ ~ ~ ~ ~ ~ 6
  & 5 ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1 & Flags & Reg 3 & Reg 2 & Reg 1 \\
  \hline
 \end{tabular}
}

\newcommand{\isarrwnf}[1]{
 \begin{tabular}{|R|c|c|c|c|c|}
  \hline
 size : & 8 & 6 & 6 & 6 & 6 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23 ~ ~ ~ ~ ~ ~ 18
  & 17 ~ ~ ~ ~ ~ ~ 12
  & 13 ~ ~ ~ ~ ~ ~ 6
  & 5 ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1 & 0 & Reg 3 & Reg 2 & Reg 1 \\
  \hline
 \end{tabular}
}

\newcommand{\isaisrw}[2]{
 \begin{tabular}{|R|c|c|c|c|c|c|}
  \hline
 size : & 8 & 4 & 2 & 6 & 6 & 6 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23 ~ ~ ~ ~ 20
  & 19 ~ ~ 18
  & 17 ~ ~ ~ ~ ~ ~ 12
  & 11 ~ ~ ~ ~ ~ ~ 6
  & 5 ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1 & Flags & #2 & Imm6 & Reg 2 & Reg 1 \\
  \hline
 \end{tabular}
}

\newcommand{\isanrnw}[1]{
 \begin{tabular}{|R|c|c|}
  \hline
 size : & 8 & 24 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23 ~ ~ ~ ~ ~ ~ ~ ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~
 ~ ~ ~ ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1 & 0 \\
  \hline
 \end{tabular}
}

\newcommand{\isaiwoo}[3]{
 \begin{tabular}{|R|c|c|c|c|c|}
  \hline
 size : & 8 & 1 & 1 & 16 & 6 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23
  & 22
  & 21 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ 6
  & 5 ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1 & #2 & #3 & Imm16 & Reg 1 \\
  \hline
 \end{tabular}
}

\newcommand{\isarwoo}[2]{
 \begin{tabular}{|R|c|c|c|c|c|}
  \hline
 size : & 8 & 1 & 10  & 6 & 6 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23
  & 22 ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~ ~  12
  & 11 ~ ~ ~ ~ ~ ~ 6
  & 5 ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1 & #2 & 0 & Reg 2 & Reg 1 \\
  \hline
 \end{tabular}
}

\newcommand{\isairw}[1]{
 \begin{tabular}{|R|c|c|c|c|c|}
  \hline
 size : & 8 & 4 & 8 & 6 & 6 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23 ~ ~ ~ ~ 20
  & 19 ~ ~ ~ ~ ~ ~ ~ ~ 12
  & 11 ~ ~ ~ ~ ~ ~ 6
  & 5 ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1 & Flags & Imm8 & Reg 2 & Reg 1 \\
  \hline
 \end{tabular}
}

\newcommand{\tblh}[0]{
 \multicolumn{1}{|C| }{~ ~ Flags ~ ~
  } & \multicolumn{1}{C| }{Syntax
  } & \multicolumn{1}{C| }{Values
  } & \multicolumn{1}{C| }{Function
 } \\
}

\newcommand{\noneyet}[1]{
  #1 & (none yet) & 0 & Reserved \\
}

\newcommand{\isam}[1]{
 \begin{tabular}{|R|c|c|c|c|c|}
  \hline
 size : & 8 & 6 & 6 & 6 & 6 \\
  \hline
 bits : & 31 ~ ~ ~ ~ ~ ~ ~ ~ 24
  & 23 ~ ~ ~ ~ ~ ~ 18
  & 17 ~ ~ ~ ~ ~ ~ 12
  & 11 ~ ~ ~ ~ ~ ~ 6
  & 5 ~ ~ ~ ~ ~ ~ 0 \\
  \hline
 function : & #1 & Flags & 0 & Reg 1 & 0\\
  \hline
 \end{tabular}
}
